﻿var dvbObjIdArray = ["networkId", "networkName", "streamId", "origNetworkId"];
var atscObjIdArray = ["streamId"];
var ROW_NUM;
var id;
var DVB = 0;
var identifyData;

window.onresize = function()
{
	$("#mainContent").css("height", function(index, value)
	{
		return ((parent.rightIframeHeight - 30) + "px");
	});
}

$(document).ready(function()
{
	var args = GetArgs();
	id = args["ID"];
	
	$("#mainContent").css("height", function(index, value)
	{
		return ((parent.rightIframeHeight - 30) + "px");
	});
	funcUpdateDisplay();
});

function funcUpdateDisplay()
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	xmlHttp.open("GET", "/goform/formIPQAM?type=" + PORT_GENERAL + "&cmd=" + GET + "&id=" + id + "&language=" + language + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);		
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				ROW_NUM = data.length - 1;
				identifyData = data[ROW_NUM];
				if(identifyData == DVB)
				{
					$("#dvbModeDiv").css("display", "");
					$("#dvbModeTr").css("display", "");
					for(var i = 0; i < ROW_NUM; i++)
					{
						$("#" + dvbObjIdArray[i]).val(data[i]);
					}					
				}
				else
				{
					$("#dvbModeDiv").css("display", "none");
					$("#dvbModeTr").css("display", "none");
					for(var i = 0; i < ROW_NUM; i++)
					{
						$("#" + atscObjIdArray[i]).val(data[i]);
					}
				}		
				refreshFlag = true;  //刷新标识符设为true表示刷新成功
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_GENERAL + "&cmd=" + SET + "&id=" + id + "&language=" + language + "&setString=";
	data += generateData();
	
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
				if(language == ENGLISH)
				{
					alert("Set Successfully!");
				}
				else
				{
					alert("设置成功！");
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, BOTTOM, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	if(identifyData == DVB)
	{
		for(var i = 0; i < ROW_NUM; i++)
		{
			if(i == 0)
			{
				data = $("#" + dvbObjIdArray[i]).val();
			}
			else
			{
				data += FIRST_DELIMITER + $("#" + dvbObjIdArray[i]).val();
			}
		}
	}
	else
	{
		for(var i = 0; i < ROW_NUM; i++)
		{
			if(i == 0)
			{
				data = $("#" + atscObjIdArray[i]).val();
			}
			else
			{
				data += FIRST_DELIMITER + $("#" + atscObjIdArray[i]).val();
			}
		}
	}
	return data;			
}

function paramCheck()
{
 	var returnFlag;
	
	if(identifyData == DVB)
	{
		returnFlag = ValidateParam($("#networkId"), "INT_DEC", 0, 65535, "<Network ID>", "<网络标识符>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#networkName"), "LENGTH", 0, 32, "<Network Name>", "<网络名称>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateName($("#networkName"), language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#origNetworkId"), "INT_DEC", 0, 65535, "<Original Network ID>", "<原始网络标识符>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}	
	returnFlag = ValidateParam($("#streamId"), "INT_DEC", 0, 65535, "<Stream ID>", "<传送流标识符>", language);
	if(returnFlag == false)
	{
		return false;
	}
	
	return true;
}
